/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.peripheral.wand.ProtoPortalSide;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class WandUtil {
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static Portal getClientPortalByUUID(UUID portalId) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        Level world = player.m_9236_();
        return WandUtil.getPortalByUUID(world, portalId);
    }

    @Nullable
    public static Portal getPortalByUUID(Level world, UUID portalId) {
        if (portalId == null) {
            return null;
        }
        Entity entity = McHelper.getEntityByUUID(world, portalId);
        if (entity instanceof Portal) {
            Portal portal = (Portal)entity;
            return portal;
        }
        return null;
    }

    public static Vec3 alignOnBlocks(Level world, Vec3 vec3, int gridCount) {
        if (gridCount == 0) {
            return vec3;
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
        return new IntBox(blockPos.m_7918_(-1, -1, -1), blockPos.m_7918_(1, 1, 1)).stream().flatMap(pos -> {
            BlockState blockState = world.m_8055_(pos);
            VoxelShape collisionShape = blockState.m_60812_((BlockGetter)world, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            List aabbs = collisionShape.m_83299_();
            if (aabbs.size() != 1) {
                aabbs.add(new AABB(pos));
            }
            return aabbs.stream();
        }).map(box -> Helper.alignToBoxSurface(box, vec3, gridCount)).min(Comparator.comparingDouble(p -> p.m_82557_(vec3))).orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderPortalAreaGridNew(VertexConsumer vertexConsumer, Vec3 cameraPos, ProtoPortalSide protoPortalSide, int color1, int color2, PoseStack matrixStack) {
        int separation = 8;
        Vec3 leftBottom = protoPortalSide.leftBottom;
        Vec3 rightBottom = protoPortalSide.rightBottom;
        Vec3 leftTop = protoPortalSide.leftTop;
        Vec3 xAxis = rightBottom.m_82546_(leftBottom);
        Vec3 yAxis = leftTop.m_82546_(leftBottom);
        Vec3 normal = xAxis.m_82537_(yAxis).m_82541_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(leftBottom.f_82479_ - cameraPos.f_82479_, leftBottom.f_82480_ - cameraPos.f_82480_, leftBottom.f_82481_ - cameraPos.f_82481_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = matrixStack.m_85850_().m_252943_();
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, Vec3.f_82478_, xAxis);
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, yAxis, yAxis.m_82549_(xAxis));
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, Vec3.f_82478_, yAxis);
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, xAxis, yAxis.m_82549_(xAxis));
        int flowCount = 3;
        Random random = new Random(color1);
        double scaling = 0.994;
        double offset1 = (1.0 - scaling) / 2.0;
        double offset2 = -offset1;
        for (int cx = 1; cx < separation; ++cx) {
            double lx = (double)cx / (double)separation;
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{xAxis.m_82490_(lx * scaling + offset1), xAxis.m_82490_(lx * scaling + offset1).m_82549_(yAxis)}, flowCount, color1, 1, matrixStack, () -> random.nextInt(10, 100));
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{xAxis.m_82490_(lx * scaling + offset2), xAxis.m_82490_(lx * scaling + offset2).m_82549_(yAxis)}, flowCount, color2, -1, matrixStack, () -> random.nextInt(10, 100));
        }
        for (int cy = 1; cy < separation; ++cy) {
            double ly = (double)cy / (double)separation;
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{yAxis.m_82490_(ly * scaling + offset1), yAxis.m_82490_(ly * scaling + offset1).m_82549_(xAxis)}, flowCount, color1, 1, matrixStack, () -> random.nextInt(10, 100));
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{yAxis.m_82490_(ly * scaling + offset2), yAxis.m_82490_(ly * scaling + offset2).m_82549_(xAxis)}, flowCount, color2, -1, matrixStack, () -> random.nextInt(10, 100));
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderPortalAreaGrid(VertexConsumer vertexConsumer, Vec3 cameraPos, ProtoPortalSide protoPortalSide, int color, PoseStack matrixStack) {
        Vec3 lineEnd;
        Vec3 lineStart;
        double ratio;
        int i;
        int separation = 8;
        Vec3 leftBottom = protoPortalSide.leftBottom;
        Vec3 rightBottom = protoPortalSide.rightBottom;
        Vec3 leftTop = protoPortalSide.leftTop;
        Vec3 xAxis = rightBottom.m_82546_(leftBottom);
        Vec3 yAxis = leftTop.m_82546_(leftBottom);
        Vec3 normal = xAxis.m_82537_(yAxis).m_82541_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(leftBottom.f_82479_ - cameraPos.f_82479_, leftBottom.f_82480_ - cameraPos.f_82480_, leftBottom.f_82481_ - cameraPos.f_82481_);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = matrixStack.m_85850_().m_252943_();
        for (i = 0; i <= separation; ++i) {
            ratio = (double)i / (double)separation;
            lineStart = xAxis.m_82490_(ratio);
            lineEnd = xAxis.m_82490_(ratio).m_82549_(yAxis);
            WireRenderingHelper.putLine(vertexConsumer, color, yAxis.m_82541_(), matrix, normalMatrix, lineStart, lineEnd);
        }
        for (i = 0; i <= separation; ++i) {
            ratio = (double)i / (double)separation;
            lineStart = yAxis.m_82490_(ratio);
            lineEnd = yAxis.m_82490_(ratio).m_82549_(xAxis);
            WireRenderingHelper.putLine(vertexConsumer, color, xAxis.m_82541_(), matrix, normalMatrix, lineStart, lineEnd);
        }
        matrixStack.m_85849_();
    }
}

